#include "Joystick.h"
#include <ShiftIn.h>

ShiftIn<7> shift1;
ShiftIn<4> shift2;

#define joyX A3
#define joyY A2
#define gain A1
#define lev A0


byte buttons[2][56] = {
  { 39, 33, 32, 43, 40, 44, 42, 41, 51, 52, 49, 48, 53, 54, 55, 50, 45, 38, 46, 47, 34, 36, 35, 37, 81, 78, 77, 79, 80, 84, 82, 83, 99, 99, 99, 64, 63, 62, 61, 60, 73, 74, 75, 76, 59, 58, 57, 56, 72, 71, 70, 69, 68, 67, 66, 65 },
  { 11, 8, 9, 10, 3, 4, 2, 5, 20, 18, 22, 21, 17, 19, 6, 7, 27, 24, 30, 31, 29, 28, 26, 25, 16, 12, 1, 0, 15, 14, 13, 23, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99 },
};



bool buttonvalues[2][56] = {
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
};

const bool initAutoSendState = true;

int xAxis_ = 0;
int xAxis_center = 0;
int xAxis_min = 511;
int xAxis_max = 511;
int yAxis_ = 0;
int yAxis_center = 0;
int yAxis_min = 511;
int yAxis_max = 511;
int rudder_ = 0;
int throttle_ = 0;
float alpha = 0.9;

Joystick_ Joystick(JOYSTICK_DEFAULT_REPORT_ID, JOYSTICK_TYPE_JOYSTICK, 85, 0, true, true, false, false, false, false, true, true, false, false, false);

void setup() {

  shift1.begin(16, 6, 10, 14);
  shift2.begin(8, 6, 9, 7);

  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  pinMode(A3, INPUT);

  for (int i = 0; i < 10; i++) {
    xAxis_center += analogRead(joyX);
  }
  xAxis_center = xAxis_center / 10;

  for (int i = 0; i < 10; i++) {
    yAxis_center += analogRead(joyY);
  }
  yAxis_center = yAxis_center / 10;

  Joystick.begin();
}

void loop() {
  CheckMinMax();
  if (shift1.update() || shift2.update()) CheckGrips();
  CheckAllAxis();
}

void CheckGrips() {

  for (int i = 0; i < shift1.getDataWidth(); i++) {
    if (shift1.state(i) != buttonvalues[0][i]) {
      Joystick.setButton(buttons[0][i], !shift1.state(i));
      buttonvalues[0][i] = shift1.state(i);
    }
  }

  for (int i = 0; i < shift2.getDataWidth(); i++) {
    if (shift2.state(i) != buttonvalues[1][i]) {
      Joystick.setButton(buttons[1][i], !shift2.state(i));
      buttonvalues[1][i] = shift2.state(i);
    }
  }
}

void CheckAllAxis(void) {

  xAxis_ = analogRead(joyX);
  if (xAxis_ < xAxis_center - 5) {
    xAxis_ = map(xAxis_, xAxis_min, xAxis_center, 0, 511);
    Joystick.setXAxis(xAxis_);
  } else if (xAxis_ > xAxis_center + 5) {
    xAxis_ = map(xAxis_, xAxis_center, xAxis_max, 512, 1023);
    Joystick.setXAxis(xAxis_);
  } else {
    xAxis_ = 511;
    Joystick.setXAxis(xAxis_);
  }

  yAxis_ = analogRead(joyY);
  if (yAxis_ < yAxis_center - 5) {
    yAxis_ = map(yAxis_, yAxis_min, yAxis_center, 0, 511);
    Joystick.setYAxis(yAxis_);
  } else if (yAxis_ > yAxis_center + 5) {
    yAxis_ = map(yAxis_, yAxis_center, yAxis_max, 512, 1023);
    Joystick.setYAxis(yAxis_);
  } else {
    yAxis_ = 511;
    Joystick.setYAxis(yAxis_);
  }

  int raw1 = analogRead(gain);
  rudder_ = alpha * raw1 + (1 - alpha) * rudder_;
  Joystick.setRudder(rudder_);

  int raw2 = analogRead(lev);
  throttle_ = alpha * raw2 + (1 - alpha) * throttle_;
  Joystick.setThrottle(throttle_);

}

void CheckMinMax() {
  if ((analogRead(joyX) < xAxis_min) && (analogRead(joyX) < xAxis_center - 5)) xAxis_min = analogRead(joyX);
  if ((analogRead(joyX) > xAxis_max) && (analogRead(joyX) > xAxis_center + 5)) xAxis_max = analogRead(joyX);
  if ((analogRead(joyY) < yAxis_min) && (analogRead(joyY) < yAxis_center - 5)) yAxis_min = analogRead(joyY);
  if ((analogRead(joyY) > yAxis_max) && (analogRead(joyY) > yAxis_center + 5)) yAxis_max = analogRead(joyY);
}
