#include "Joystick.h"
#include "Adafruit_MCP23X17.h"

#define joyX A0
#define joyY A1
#define gain A3
#define lev A2

Adafruit_MCP23X17 mcp1;
Adafruit_MCP23X17 mcp2;
Adafruit_MCP23X17 mcp3;
Adafruit_MCP23X17 mcp4;
Adafruit_MCP23X17 mcp5;

byte buttons[5][16] = {
  { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
  { 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 },
  { 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 },
  { 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63 },
  { 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 },
};

bool buttonvalues[5][16] = {
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
};

const bool initAutoSendState = true;

int xAxis_ = 0;
int xAxis_center = 0;
int xAxis_min = 511;
int xAxis_max = 511;
int yAxis_ = 0;
int yAxis_center = 0;
int yAxis_min = 511;
int yAxis_max = 511;
int rudder_ = 0;
int throttle_ = 0;
float alpha = 0.5;

Joystick_ Joystick(JOYSTICK_DEFAULT_REPORT_ID, JOYSTICK_TYPE_JOYSTICK, 86, 0, true, true, false, false, false, false, true, true, false, false, false);

void setup() {

  mcp1.begin_I2C(0x20);
  mcp2.begin_I2C(0x21);
  mcp3.begin_I2C(0x22);
  mcp4.begin_I2C(0x23);
  mcp5.begin_I2C(0x24);

  for (int i = 0; i < 16; i++) {
    mcp1.pinMode(i, INPUT_PULLUP);
  }
  for (int i = 0; i < 16; i++) {
    mcp2.pinMode(i, INPUT_PULLUP);
  }
  for (int i = 0; i < 16; i++) {
    mcp3.pinMode(i, INPUT_PULLUP);
  }
  for (int i = 0; i < 16; i++) {
    mcp4.pinMode(i, INPUT_PULLUP);
  }

  for (int i = 0; i < 16; i++) {
    mcp5.pinMode(i, INPUT_PULLUP);
  }

  for (int i = 0; i < 10; i++) {
    xAxis_center += analogRead(joyX);
  }
  xAxis_center = xAxis_center / 10;

  for (int i = 0; i < 10; i++) {
    yAxis_center += analogRead(joyY);
  }
  yAxis_center = yAxis_center / 10;

  Joystick.begin();
}

void loop() {
  CheckMinMax();
  CheckGrips();
  CheckAllAxis();
}

void CheckGrips() {
  for (int i = 0; i < 16; i++) {
    if (mcp1.digitalRead(i) != buttonvalues[0][i]) {
      Joystick.setButton(buttons[0][i], !mcp1.digitalRead(i));
      buttonvalues[0][i] = mcp1.digitalRead(i);
    }
  }

  for (int i = 0; i < 16; i++) {
    if (mcp2.digitalRead(i) != buttonvalues[1][i]) {
      Joystick.setButton(buttons[1][i], !mcp2.digitalRead(i));
      buttonvalues[1][i] = mcp2.digitalRead(i);
    }
  }

  for (int i = 0; i < 16; i++) {
    if (mcp3.digitalRead(i) != buttonvalues[2][i]) {
      Joystick.setButton(buttons[2][i], !mcp3.digitalRead(i));
      buttonvalues[2][i] = mcp3.digitalRead(i);
    }
  }

  for (int i = 0; i < 16; i++) {
    if (mcp4.digitalRead(i) != buttonvalues[3][i]) {
      Joystick.setButton(buttons[3][i], !mcp4.digitalRead(i));
      buttonvalues[3][i] = mcp4.digitalRead(i);
    }
  }

  for (int i = 0; i < 16; i++) {
    if (mcp5.digitalRead(i) != buttonvalues[4][i]) {
      Joystick.setButton(buttons[4][i], !mcp5.digitalRead(i));
      buttonvalues[4][i] = mcp5.digitalRead(i);
    }
  }
}

void CheckAllAxis(void) {

  xAxis_ = analogRead(joyX);
  xAxis_ = map(xAxis_, 1023, 0, 0, 1023);
  if (xAxis_ < xAxis_center - 5) {
    xAxis_ = map(xAxis_, xAxis_min, xAxis_center, 0, 511);
    Joystick.setXAxis(xAxis_);
  } else if (xAxis_ > xAxis_center + 5) {
    xAxis_ = map(xAxis_, xAxis_center, xAxis_max, 512, 1023);
    Joystick.setXAxis(xAxis_);
  } else {
    xAxis_ = 511;
    Joystick.setXAxis(xAxis_);
  }

  yAxis_ = analogRead(joyY);
  if (yAxis_ < yAxis_center - 5) {
    yAxis_ = map(yAxis_, yAxis_min, yAxis_center, 0, 511);
    Joystick.setYAxis(yAxis_);
  } else if (yAxis_ > yAxis_center + 5) {
    yAxis_ = map(yAxis_, yAxis_center, yAxis_max, 512, 1023);
    Joystick.setYAxis(yAxis_);
  } else {
    yAxis_ = 511;
    Joystick.setYAxis(yAxis_);
  }

  int raw1 = analogRead(gain);
  rudder_ = alpha * raw1 + (1 - alpha) * rudder_;
  Joystick.setRudder(rudder_);

  int raw2 = analogRead(lev);
  throttle_ = alpha * raw2 + (1 - alpha) * throttle_;
  Joystick.setThrottle(throttle_);

}

void CheckMinMax() {
  if ((analogRead(joyX) < xAxis_min) && (analogRead(joyX) < xAxis_center - 8)) xAxis_min = analogRead(joyX);
  if ((analogRead(joyX) > xAxis_max) && (analogRead(joyX) > xAxis_center + 8)) xAxis_max = analogRead(joyX);
  if ((analogRead(joyY) > yAxis_min) && (analogRead(joyY) > yAxis_center - 8)) yAxis_min = analogRead(joyY);
  if ((analogRead(joyY) < yAxis_max) && (analogRead(joyY) < yAxis_center + 8)) yAxis_max = analogRead(joyY);
}
